package pt.caf_pbs.schooldiskclient.handler;

import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import pt.caf_pbs.schooldiskclient.dto.InstructorDTO;
import pt.caf_pbs.schooldiskclient.dto.LectureDTO;
import pt.caf_pbs.schooldiskclient.dto.SchoolInfoDTO;
import pt.caf_pbs.schooldiskclient.dto.SubjectDTO;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class JsonHandler {

    public static SchoolInfoDTO deSerializeJson2SchoolInfoDTO(String resp) throws JSONException {
        SchoolInfoDTO data = new SchoolInfoDTO();
            JSONObject mResponseObject = new JSONObject(resp);
            data.setName(mResponseObject.getString("name"));
            data.setVersion(mResponseObject.getString("version"));
            return data;
    }

    public static List<InstructorDTO> deSerializeJson2ListInstructorDTO(String resp) throws JSONException {
        JSONArray jsonResponse = new JSONArray(resp);
        List<InstructorDTO> list = new ArrayList<>();
        for(int i = 0; i<jsonResponse.length();i++){
            JSONObject jsonChildNode = jsonResponse.getJSONObject(i);
            String name = jsonChildNode.optString("name");
            String initials = jsonChildNode.optString("initials");
            list.add(new InstructorDTO(initials, name));
        }
        return list;
    }
    public static String serializeInstructorDTO2Json(InstructorDTO obj) throws JSONException {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("name", obj.getName());
        jsonObject.put("initials", obj.getInitials());
        return jsonObject.toString();

    }
    public static List<SubjectDTO> deSerializeJson2ListSubjectDTO(String resp) throws JSONException {
        JSONArray jsonResponse = new JSONArray(resp);
        List<SubjectDTO> list = new ArrayList<>();
        for(int i = 0; i<jsonResponse.length();i++){
            JSONObject jsonChildNode = jsonResponse.getJSONObject(i);
            String designation = jsonChildNode.optString("designation");
            String initials = jsonChildNode.optString("initials");
            list.add(new SubjectDTO(initials, designation));
        }
        return list;
    }

    public static List<LectureDTO> deSerializeJson2ListLectureDTO(String resp) throws JSONException {
        JSONArray jsonResponse = new JSONArray(resp);
        List<LectureDTO> list = new ArrayList<>();
        for(int i = 0; i<jsonResponse.length();i++){
            JSONObject jsonChildNode = jsonResponse.getJSONObject(i);
            JSONObject _jsonChildNode = jsonChildNode.optJSONObject("subject");
            String designation = _jsonChildNode.optString("designation");
            String initials = _jsonChildNode.optString("initials");
            SubjectDTO subjectDTO = new SubjectDTO(initials, designation);
            list.add(new LectureDTO(subjectDTO));
        }
        return list;
    }

    public static String serializeLectureDTO2Json(LectureDTO obj) throws JSONException {
        SubjectDTO subjectDTO = obj.getSubject();
        JSONObject subject = new JSONObject();
        subject.put("designation", subjectDTO.getDesignation());
        subject.put("initials", subjectDTO.getInitials());
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("subject", subject);
        return jsonObject.toString();

    }

}
